/**
 * @fileOverview 收藏管理页面快捷键
 * @author littleli
 * @date 12-5-2 - 下午18：00
 */

(function(window) {
	var codeToKey = {
		37: 'left',
		38: 'up',
		39: 'right',
		40: 'down',
		88: 'x',
		67: 'c',
		86: 'v',
		46: 'delete'
	};

	// 只允许内容区list拥有多选状态
	document.addEventListener("keydown", function(event){
		// 设置多选时的标识位
		if (event.ctrlKey ) {
			bmm.multiChose = 1;
		} else if (event.shiftKey){
			bmm.multiChose = 2;
		} else {
			bmm.multiChose = false;
		}

		if (46 === event.keyCode) { // delte键的功能
			bmm.deleteFunc();
		}
	}, false);
	
	function listKeydownHandler(e) {
		
	}
	
	// 绑定
	list.addEventListener('keydown', function(e) {
		var actionToElement = {
			up: 'previousElementSibling',
			down: 'nextElementSibling'
		}

		var action = codeToKey[e.keyCode];
		if (action === 'up' || action === 'down') {
			if (bmm && bmm.leadListItem) {
				var overAnchor = false;
				// 重复多选时的判断逻辑
				var nextElement = (bmm.leadListItem._element[actionToElement[action]] === bmm.anchorItem._element && !bmm.leadListItem.selected) ? 
					(overAnchor = true) && bmm.anchorItem._element[actionToElement[action]] : bmm.leadListItem._element[actionToElement[action]];
				var nextItem = nextElement && nextElement.listitem;
				// 当用键盘操作时，多选状态下反选时，
				// 需要判断此时应该反选自身的item还是下一个item
				// 反选时当自身以及下一个元素为选中时，那么此时反选自身item
				if (event.shiftKey) {
					bmm.multiChose = 1;
				}
				var element = ( (( nextItem && nextItem.selected) && bmm.leadListItem.selected) || 
								(( !overAnchor && nextItem && !nextItem.selected) && !bmm.leadListItem.selected) )
					? bmm.leadListItem._element : nextElement;
				simulateEvent(element);
			}
		} else if (action === 'x' || action === 'c' || action === 'v') {
			if (event.ctrlKey) {
				bmm.curListItem = bmm.leadListItem;
				if (bmm.curListItem) {
					actionFunc(action, 'content');
				} else {
					actionFunc(action, 'nav');
				}
				
			}
		}
	}, false);
	
	document.getElementById('folder-tree').addEventListener('keydown', function(e) {
		// 如果没有选中的treeItem，那么直接退出
		if (!bmm || !bmm.curTreeItem) 
			return;
			
		var action = codeToKey[e.keyCode];
		var itemToSelect = null;
		
		switch (action) {
			case 'down':
				itemToSelect = getNext(bmm.curTreeItem);
				break;
			case 'up':
				itemToSelect = getPrevious(bmm.curTreeItem);
				break;
			case 'left':
				if (bmm.curTreeItem.expanded) {
					bmm.curTreeItem.expand();
				} else {
					itemToSelect = bmm.curTreeItem._root;
				}
				break;
			case 'right':
				if (bmm.curTreeItem.expanded) {
					itemToSelect = getNext(bmm.curTreeItem);
				} else {
					bmm.curTreeItem.expand();
				}
				break;
			case 'delete': 
				if (bmm.curTreeItem && bmm.curTreeItem !== bmm.rootTreeItem) {
					// 如果此时选中离线未备份数据的话，那么直接返回
					if (bmm.curTreeID.indexOf('offline-') > -1) 
						return;
					var result = confirm('确定要删除选中的1个项目吗？');
					if (result) {
						qqbrowser.bookmark.removeTree(Number(bmm.curTreeItem.id));
						bmm.curTreeItem = null;
						bmm.curTreeID = null;
					}
				}
				break;
			default:
				if (action === 'x' || action === 'c' || action === 'v') {	
					if (event.ctrlKey) {
						actionFunc(action, 'nav');
					}
				}
		}
		simulateEvent((itemToSelect && itemToSelect._element));
	}, false);
	
	
	function actionFunc(action, type) {
		if (!action || !type)
			return;
		
		var actionToFunc = {
			x: 'cut',
			c: 'copy',
			v: 'paste'
		}
		
		bmm.menuType = type;
		var func = actionToFunc[action];
		bmm[func].call(this);
	}
	
	function simulateEvent(element) {
		if (!element)
			return;
	
		// 模拟一个点击
		var event = document.createEvent('MouseEvents');
		event.initMouseEvent('click', true, true, document.defaultView);
		element.dispatchEvent(event);
	};
	
	
	/**
	* Helper function that returns the next visible tree item.
	* @param {cr.ui.TreeItem} item The tree item.
	* @return {cr.ui.TreeItem} The found item or null.
	*/
	function getNext(item) {
		if (item.expanded) {
		  var firstChild = item._treeChildren.children[0] ? 
			  item._treeChildren.children[0].treeitem : null;
		  if (firstChild) {
			return firstChild;
		  }
		}

		return getNextHelper(item);
	}
	
	/**
	* Another helper function that returns the next visible tree item.
	* @param {cr.ui.TreeItem} item The tree item.
	* @return {cr.ui.TreeItem} The found item or null.
	*/
	function getNextHelper(item) {
		if (!item)
		  return null;

		var nextSibling = (item._element && item._element.nextElementSibling) ? 
			item._element.nextElementSibling.treeitem : null;
		if (nextSibling) {
		  return nextSibling;
		}
		return getNextHelper(item._root);
	}	

		
	/**
    * Helper function that returns the previous visible tree item.
    * @param {cr.ui.TreeItem} item The tree item.
    * @return {cr.ui.TreeItem} The found item or null.
    */
   function getPrevious(item) {
     var previousSibling = item._element.previousElementSibling ? 
		item._element.previousElementSibling.treeitem : null;
     return previousSibling ? getLastHelper(previousSibling) : item._root;
   }

	/**
	* Helper function that returns the last visible tree item in the subtree.
	* @param {cr.ui.TreeItem} item The item to find the last visible item for.
	* @return {cr.ui.TreeItem} The found item or null.
	*/
	function getLastHelper(item) {
		if (!item)
			return null;
		if (item.expanded && item.hasChildren) {
			var length = item._treeChildren.children.length
			var lastChild = item._treeChildren.children[length - 1].treeitem;
			return getLastHelper(lastChild);
		}
		return item;
	}
	

	document.addEventListener("keyup", function(event){
		// 在keyup时，清空多选的标识位
		if (!event.shiftKey) {
			bmm.multiChose = false;
		}
	}, false);

})(window);